% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{Rule8}
\alias{Rule8}
\title{Rule 8}
\usage{
Rule8(x, nPoints = 8, zoneB, ...)
}
\arguments{
\item{x}{Numerical vector}

\item{nPoints}{Sequence of consequtive points to be evaluated}

\item{zoneB}{Vector of zone borders}

\item{...}{unspecified arguments of a function}
}
\value{
Vector of the same length as x
}
\description{
Eight points in a row outside 1 standard deviation of the mean in both directions.
}
\details{
0 means: ok \cr
1 means: violation \cr

inequality used during evaluation
During calculation of EvaluateRules function wiht controlLimitDistance <= 1, the evaluation of this rule is suppressed
}
\examples{
limits = CalculateLimits(x = rnorm(10), lcl = NA, cl = 100, ucl = NA, type = 'i')
zones = CalculateZoneBorders(limits)
Rule8(x = rnorm(20), zoneB = zones, nPoints = 8)
#zones is object created by function CalculateZoneBorders()
}
