% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dsep}
\alias{dsep}
\title{Returns density from Skewed Exponential Power distribution}
\usage{
dsep(x, m = 0, a = 1, b = 1, lambda = 1)
}
\arguments{
\item{x}{(numeric) - value in the range \eqn{(-\infty, \infty)} to evaluate
the density.}

\item{m}{(numeric) - location parameter. Must be in the range
\eqn{(-\infty, \infty)}.}

\item{a}{(numeric) - scale parameter. Must be in the range \eqn{(0, \infty)}.}

\item{b}{(numeric) - shape parameter. Must be in the range \eqn{(0, \infty)}.}

\item{lambda}{(numeric) - skewness parameter. Must be in the range \eqn{(-\infty, \infty)}.}
}
\value{
a vector containing the values for the densities.
}
\description{
The \code{dsep} returns the density at point x for the
Gamma distribution with parameters \eqn{a}, \eqn{b}.
}
\details{
The  SEP is a exponential power distribution controlled
by four parameters, with formula:
\deqn{ f(x; m, b, a, \lambda) = 2 \Phi(w) e^{-|z|^b/b}/(c)}
where:
\deqn{z = (x-m)/a}
\deqn{w = sign(z) |z|^{(b/2)} \lambda \sqrt{2/b}}
\deqn{c = 2 ab^{(1/b)-1} \Gamma(1/b)}
with \eqn{\Phi} the cumulative normal distribution with mean zero and variance
one.
}
