% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_freq.R
\name{link_freq}
\alias{link_freq}
\title{Frequency of host-symbiont association}
\usage{
link_freq(
  x,
  fx,
  HS,
  percentile = 0.01,
  sep = "-",
  below.p = TRUE,
  res.fq = TRUE
)
}
\arguments{
\item{x}{List of trimmed matrices produced by
\code{\link[=trimHS_maxC]{trimHS_maxC()}} or
\code{\link[=trimHS_maxI]{trimHS_maxI()}}.}

\item{fx}{Vector of statistics produced with \code{\link[=geo_D]{geo_D()}},
\code{\link[=paco_ss]{paco_ss()}} or \code{\link[=paraF]{paraF()}}}

\item{HS}{Host-symbiont association matrix.}

\item{percentile}{Percentile to evaluate (\emph{p}). Default is
\code{0.01} (1\\\%).}

\item{sep}{Character that separates host and symbiont labels.}

\item{below.p}{Determines whether frequencies are to be computed below or
above the percentile set. Default is \code{TRUE}.}

\item{res.fq}{Determines whether a correction to avoid one-to-one
associations being overrepresented in the percentile evaluated.
If \code{TRUE} (default) a residual frequency value (observed -
expected frequency) is computed for each host-symbiont association.}
}
\value{
A dataframe with host-symbiont associations in rows. The first and
second columns display the names of the host and symbiont terminals,
respectively. The third column designates the host-symbiont
association by pasting the names of the terminals, and the fourth
column displays the frequency of occurrence of each host-symbiont
association. If \code{res.fq = TRUE}, column 5 displays the
corrected frequencies as a residual.
}
\description{
Determines the frequency (or residual/corrected frequency) of each
host-symbiont association in a given percentile of cases that maximize
phylogenetic (in)congruence.
}
\section{NOTE}{

The \code{res.fq = TRUE} correction is recommended in tanglegrams with
large portion of multiple (as opposed to one-to-one) host-symbiont
associations. For future usage, frequencies of host-symbiont
associations above a given percentile values can also be computed
setting \code{below.p = FALSE}.
}

\examples{
\donttest{
data(amph_trem)
N = 10 #for the example, we recommend 1e+4 value
n = 8

TAM <- trimHS_maxC(N, am_matrix, n, check.unique = TRUE)
PACO <- paco_ss(TAM, amphipod, trematode, symmetric = TRUE,
                ei.correct = "sqrt.D", strat = "parallel", cl = 8)
LFPACO <- link_freq(TAM, PACO, am_matrix, percentile = 0.01,
                    below.p = TRUE, res.fq = TRUE)
}

}
