% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ernet.R
\name{predict.ernet}
\alias{predict.ernet}
\alias{predict.alspath}
\title{Make predictions from an ernet object}
\usage{
\method{predict}{ernet}(object, newx, s = NULL, type = "response", ...)
}
\arguments{
\item{object}{fitted \code{\link{ernet}} model object.}

\item{newx}{matrix of new values for \code{x} at which predictions are to be
made. NOTE: \code{newx} must be a matrix, \code{predict} function does not
accept a vector or other formats of \code{newx}.}

\item{s}{value(s) of the penalty parameter \code{lambda} at which predictions
are to be made. Default is the entire sequence used to create the model.}

\item{type}{type of prediction required. Only \code{response} is available.
Gives predicted response for regression problems.}

\item{\dots}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this functions predicts fitted values from
a fitted ernet object.
}
\details{
\code{s} is the new vector at which predictions are to be made. If
  \code{s} is not in the lambda sequence used for fitting the model, the
  \code{predict} function will use linear interpolation to make predictions.
  The new values are interpolated using a fraction of predicted values from
  both left and right \code{lambda} indices.
}
\seealso{
\code{\link{ernet}}, \code{\link{coef.ernet}},
  \code{\link{plot.ernet}}, \code{\link{print.ernet}}
}
\author{
Yuwen Gu and Hui Zou\cr

  Maintainer: Yuwen Gu <yuwen.gu@uconn.edu>
}
\keyword{models}
\keyword{regression}
