% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ernet.R
\name{print.ernet}
\alias{print.ernet}
\title{Print an ernet object}
\usage{
\method{print}{ernet}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted \code{\link{ernet}} object.}

\item{digits}{significant digits in the output.}

\item{\dots}{additional print arguments.}
}
\value{
a two-column matrix, the first columns is the number of nonzero
  coefficients and the second column is \code{Lambda}.
}
\description{
Print a summary of the ernet path at each step along the path.
}
\details{
The call that produced the \code{\link{ernet}} object is printed,
  followed by a two-column matrix with columns \code{Df} and \code{Lambda}.
  The \code{Df} column is the number of nonzero coefficients.
}
\examples{

set.seed(1)
n <- 100
p <- 400
x <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)
tau <- 0.90
pf <- abs(rnorm(p))
pf2 <- abs(rnorm(p))
lambda2 <- 1
m1 <- ernet(y = y, x = x, tau = tau, eps = 1e-8, pf = pf,
            pf2 = pf2, standardize = FALSE, intercept = FALSE,
            lambda2 = lambda2)
print(m1)

}
\author{
Yuwen Gu and Hui Zou\cr

  Maintainer: Yuwen Gu <yuwen.gu@uconn.edu>
}
\keyword{models}
\keyword{regression}
