% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onload.R
\name{delete_rec_service}
\alias{delete_rec_service}
\title{Delete an Azure recommender service}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} and \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} classes.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{delete_rec_service(name, confirm = TRUE, free_resources = TRUE)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the recommender service.
\item \code{confirm}: Whether to ask for confirmation before deleting.
\item \code{free_resources}: Whether to delete the individual resources as well as the recommender template.
}
}

\section{Value}{

NULL on successful deletion.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# delete a recommender service
rg$delete_rec_service("myrec")

}
}
\seealso{
\link{create_rec_service}, \link{delete_rec_service}
}
