% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStreams.R
\name{createStreams}
\alias{createStreams}
\title{Create stream network from DEM}
\usage{
createStreams(
  DEM,
  threshold,
  vector = NULL,
  save_path = NULL,
  n.cores = NULL,
  force_update_wbt = FALSE,
  silent_wbt = TRUE
)
}
\arguments{
\item{DEM}{The path to a digital elevation model file with .tif extension, or a terra spatRaster object. It is usually advisable to have already hydro-processed the DEM to remove artificial depressions. See \code{\link[=hydroProcess]{hydroProcess()}}.}

\item{threshold}{The accumulation threshold in DEM cells necessary to start defining a stream.}

\item{vector}{Output file specifications. NULL for no vector file at all; "env" for only a variable returned to the R environment; or, to return to environment and save to disk, "gpkg" for a geopackage file, "shp" for a shapefile.}

\item{save_path}{An optional path in which to save the newly created stream network. If left NULL will save it in the same directory as the provided DEM or, if the DEM is a terra object, return only terra objects.}

\item{n.cores}{The maximum number of cores to use. Leave NULL to use all cores minus 1.}

\item{force_update_wbt}{Whitebox Tools is by default only downloaded if it cannot be found on the computer, and no check are performed to ensure the local version is current. Set to TRUE if you know that there is a new version and you would like to use it.}

\item{silent_wbt}{Should Whitebox tools messages be suppressed? This function prints messages to the console already but these messages can be useful if you need to do some debugging.}
}
\value{
A raster representation of streams and, if requested, a vector representation of streams. Returned as terra objects and saved to disk if \code{save_path} is not null.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Creates a stream network from a provided DEM. In most cases it is advisable to first hydro-process the DEM (see \code{\link[=hydroProcess]{hydroProcess()}}) to remove depressions which preclude continuous flow from one DEM cell to the next.
}
\details{
This function is essentially a convenient wrapper around three WhiteboxTools geospatial tools (\code{\link[whitebox:wbt_d8_flow_accumulation]{whitebox::wbt_d8_flow_accumulation()}}, \code{\link[whitebox:wbt_d8_pointer]{whitebox::wbt_d8_pointer()}}, and \code{\link[whitebox:wbt_extract_streams]{whitebox::wbt_extract_streams()}}) and some terra functions to convert rasters to vector files.
}
\examples{
\dontshow{if (whitebox::check_whitebox_binary()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

hydroDEM <- hydroProcess(elev, 200, streams, n.cores = 2)
res <- createStreams(hydroDEM, 50, n.cores = 2)

terra::plot(res$streams_derived)
}
\dontshow{\}) # examplesIf}
}
\author{
Ghislain de Laplante (gdela069@uottawa.ca or ghislain.delaplante@yukon.ca)
}
