% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulate.R
\name{simulate}
\alias{simulate}
\title{Randomly generate a adjacency matrix based on which to simulate data}
\usage{
simulate(n, p, m1, m2)
}
\arguments{
\item{n}{Sample size}

\item{p}{The number of vertices in graph or the number of variables}

\item{m1}{The number of edges in the true graph}

\item{m2}{The number of elements in adjacency matrix that stay in different states, 
i.e., 0 or 1, in true and prior graphs}
}
\value{
A list including the simulated data, real adjacency matrix and a prior adjacency matrix
  \item{data}{simulated data}
  \item{realnetwork}{real adjacency matrix}
  \item{priornetowrk}{prior adjacency matrix}
}
\description{
According to a given edge density, first generate the adjacency matrix P of a graph. 
  Based on P, the simulated multivariate normal data is generated with
  mean zero and a specified given precision matrix
}
\examples{
  set.seed(1)
  d=simulate(n=100,p=200, m1=100, m2=30)
  d$data
  d$realnetwork
  d$priornetwork
  
}
\author{
Jie Zhou
}
