% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladder.R
\name{get_gm_leaderboard}
\alias{get_gm_leaderboard}
\title{Grandmaster Leaderboard}
\usage{
get_gm_leaderboard(region_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Provides a full listing of players currently in the grandmaster leaderboard. Also provides other
information such as player profile information, records (match record, MMR, etc.), and clans.
}
\note{
This API call is currently not supported for the China region (region_id = 5).
}
\examples{
\donttest{
# Obtain GM leaderboard for the Korea region
try(get_gm_leaderboard(region_id = 3))
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   \item \href{https://starcraft2.com/en-us/ladder/grandmaster/1}{Grandmaster League}
   }
}
\seealso{
Other ladder data API calls: 
\code{\link{get_season}()}
}
\concept{ladder data API calls}
