% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game_data.R
\name{get_league_data}
\alias{get_league_data}
\title{League Data}
\usage{
get_league_data(season_id, queue_id, team_type, league_id, host_region = "us")
}
\arguments{
\item{season_id}{A numeric argument indicating a particular ladder season. Currently, league data
is only available for season 28 and higher (i.e. data prior to this season is inaccessible).}

\item{queue_id}{\itemize{
   \item 1 = WoL 1v1
   \item 2 = WoL 2v2
   \item 3 = WoL 3v3
   \item 4 = WoL 4V4
   \item 101 = HotS 1v1
   \item 102 = HotS 2v2
   \item 103 = HotS 3v3
   \item 104 = HotS 4v4
   \item 201 = LotV 1v1
   \item 202 = LotV 2v2
   \item 203 = LotV 3v3
   \item 204 = LotV 4v4
   \item 206 = LotV Archon
}}

\item{team_type}{\itemize{
    \item 0 = Arranged
    \item 1 = Random
}}

\item{league_id}{\itemize{
   \item 0 = Bronze
   \item 1 = Silver
   \item 2 = Gold
   \item 3 = Platinum
   \item 4 = Diamond
   \item 5 = Masters
   \item 6 = Grandmaster
}}

\item{host_region}{The host region that the API call will be sent to. For \code{get_league_data}, the host
region affects the data you will receive (i.e. different regions will result in different data).
Must be one of "us", "eu", "kr", "tw", "cn". For more information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
League data is divided into 3 tiers for each league (with the exception of grandmaster, which only has
1 tier) and further divided into a number of divisions depending on how many players are in a given league.
League data contains the number of divisions, the unique ladder ID of each division and the
total player count contained within each division.
}
\note{
League data is only available for season 28 and higher.
}
\examples{
\donttest{
# Get full league data for Season 30, LotV 1v1, arranged teams,
# Masters league, U.S. region.
try({
    data <- get_league_data(season_id = 30,
                            queue_id = 201,
                            team_type = 0,
                            league_id = 5,
                            host_region = "us")
})
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
\seealso{
Other game data API calls: 
\code{\link{get_ladder_data}()},
\code{\link{get_season_data}()}
}
\concept{game data API calls}
