% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcamb_classic.R
\name{pcamb_classic}
\alias{pcamb_classic}
\title{pcamb_classic}
\usage{
pcamb_classic(X, ncomp, alpha, prepro)
}
\arguments{
\item{X}{Matrix with observations that will used to fit the PCA model.}

\item{ncomp}{An integer indicating the number of PCs that the model will have.}

\item{alpha}{A number between 0 and 1 indicating the type I risk assumed to calculate
the Upper Control Limits (UCLs) for the Squared Prediction Error (SPE), the Hotelling's
T^2_A and the scores. The confidence level of these limits will be \code{(1-alpha)*100}.}

\item{prepro}{A string indicating the preprocessing to be performed on X. Its possible
values are: \code{"none"}, for any preprocessing, \code{"cent"}, for a mean-centering,
or \code{"autosc"}, for a mean-centering and unitary variance scaling (autoscaling).}
}
\value{
list with elements containing information about PCA model:
\itemize{
\item \code{m}: mean vector.
\item \code{s}: standard deviation vector.
\item \code{P}: loading matrix with the loadings of each PC stored as columns.
\item \code{Pfull}: full loading matrix obtained by the svd,
\item \code{lambda}: vector with the variance of each PC.
\item \code{limspe}: Upper Control Limit for the SPE with a confidence level
(1-alpha)*100 \%.
\item \code{limt2}: Upper Control Limit for the T^2_A with a confidence level
(1-alpha)*100 \%.
\item \code{limits_t}: Upper control Limits for the scores with a confidence level
(1-alpha)*100 \%.
\item \code{prepro}: string indicating the type of preprocessing performed on X.
\item \code{ncomp}: number of PCs of the PCA model, A.
\item \code{alpha}: value of the type I risk assumed to calculate the Upper Control
Limits of the SPE, T^2_A and scores.
\item \code{n}: dimension of the number of rows in X.
\item \code{S}: covariance matrix of X.
}
}
\description{
Principal Component Analysis (PCA) model fitting according to a matrix X using singular
value decomposition (svd)
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X, 3, 0.1, "autosc") # PCA-MB with all observations
pcamodel.ref <- pcamb_classic(X[1:40,], 2, 0.05, "cent") # PCA-MB with first 40 
# observations
}
