% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_construction.R
\name{load_scdata}
\alias{load_scdata}
\title{Load, filter and normalize scRNA-seq/snRNA-seq data}
\usage{
load_scdata(
  ref,
  data_type = c("cellranger", "h5", "matrix"),
  meta_info,
  nfeature_rna = 200,
  percent_mt = 40,
  cc.genes = NULL,
  vars_to_regress = c("percent_mt", "phase"),
  id,
  verbose,
  ...
)
}
\arguments{
\item{ref}{path to scRNA-seq/snRNA-seq data.}

\item{data_type}{a character value specifying data type of the input scRNA-seq/snRNA-seq data, should be one of "cellranger", "h5", "matrix".}

\item{meta_info}{a data.frame with rows representing cells, columns representing cell attributes.}

\item{nfeature_rna}{minimum # of features with non-zero UMIs. Cells with # of features lower than nfeature_rna will be removed. Default to 200.}

\item{percent_mt}{maximum percentage of mitochondria (MT) mapped UMIs. Cells with MT percentage higher than percent_mt will be removed. Default to 40.}

\item{cc.genes}{cell-cycle genes curated by Seurat. Can be loaded via \code{data(cc.genes)}}

\item{vars_to_regress}{a list of character values indicating the variables to regress for SCTransform normalization step. Default is to regress
out MT percentage ("percent_mt") & cell cycle effects ("phase")}

\item{id}{a character value specifying project or sample id. Only used for printing purposes.}

\item{verbose}{logical value indicating whether to print messages.}

\item{...}{additional parameters passed to \code{\link[Seurat]{SCTransform}}.}
}
\value{
a \code{\link[Seurat]{Seurat-class}} object.
}
\description{
Load and preprocess scRNA-seq/snRNA-seq data using seurat SCTransform workflow.
}
\details{
For more details, refer to \code{\link{construct_ref}}
}
\examples{
\donttest{
samplepath1 <- paste0(system.file("extdata", package = "SCdeconR"), "/refdata/sample1")
samplepath2 <- paste0(system.file("extdata", package = "SCdeconR"), "/refdata/sample2")
ref_list <- c(samplepath1, samplepath2)
phenopath1 <- paste0(system.file("extdata", package = "SCdeconR"),
"/refdata/phenodata_sample1.txt")
phenopath2 <- paste0(system.file("extdata", package = "SCdeconR"),
"/refdata/phenodata_sample2.txt")
phenodata_list <- c(phenopath1,phenopath2)
tmp <- load_scdata(
  ref = ref_list[[1]],
  data_type = c("cellranger"),
  meta_info = data.table::fread(file = phenodata_list[[1]], check.names = FALSE, header = TRUE),
  nfeature_rna = 50,
  vars_to_regress = c("percent_mt"),
  id = 1,
  verbose = TRUE)
}
}
