% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sdi.R
\name{print.sdi}
\alias{print.sdi}
\title{Print Method for Objects of Class sdi}
\usage{
\method{print}{sdi}(x, ...)
}
\arguments{
\item{x}{A required object of the class \code{sdi}, obtained from a call to
the function \code{\link{sdi}}.}

\item{\dots}{Further arguments to be passed are ignored in this function.}
}
\value{
If the argument \code{x} is of required type, \code{print.sdi} prints
  the original or adjusted SDI or RAI overall index values and returns an
  invisible copy of these scores.
}
\description{
S3 method to print objects of the class \code{sdi}.
}
\details{
This \code{print} method prints the main results obtained from calculating
the original or adjusted SDI or RAI index, which are the overall index values
or SDI or RAI scores. The output can be long, and thus, entries may be
omitted.
}
\examples{
## attach dataset to search path (to use variable names)
attach(learning_motivation)

## adjusted index print
padj <- print(sdi(intrinsic, identified, introjected, external))
## compactly displayed structure of the object padj
str(padj)

## original index print
sdi(intrinsic, identified, introjected, external, compute.adjusted = FALSE)
}
\references{
Uenlue, A. (2016) Adjusting potentially confounded scoring
  protocols for motivation aggregation in organismic integration theory: An
  exemplification with the relative autonomy or self-determination index.
  \emph{Frontiers in Educational Psychology}, \bold{7}(272), 1--4. URL
  \url{https://doi.org/10.3389/fpsyg.2016.00272}.
}
\seealso{
The main function of the package, which creates objects of the class
  \code{sdi}: \code{\link{sdi}} for the original and adjusted SDI or RAI
  index. \code{\link{plot.sdi}}, the S3 method for plotting objects of the
  class \code{sdi}; \code{\link{summary.sdi}}, the S3 method for summarizing
  objects of the class \code{sdi}. See also \code{\link{SDT-package}} for
  general information about this package.
}
\author{
Ali Uenlue <ali.uenlue@icloud.com>
}
\keyword{methods}
\keyword{print}
