% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sdi.R
\name{summary.sdi}
\alias{summary.sdi}
\title{Summary Method for Objects of Class sdi}
\usage{
\method{summary}{sdi}(object, ...)
}
\arguments{
\item{object}{A required object of the class \code{sdi}, obtained from a call
to the function \code{\link{sdi}}.}

\item{\dots}{Further arguments to be passed are ignored in this function.}
}
\value{
If the argument \code{object} is of required type, \code{summary.sdi}
  prints simple summary statistics of the list components values, and
  invisibly returns \code{object}.
}
\description{
S3 method to summarize objects of the class \code{sdi}.
}
\details{
This \code{summary} method outlines the results obtained from the original or
adjusted SDI or RAI index computation by printing simple summary statistics
of the values obtained for the confounded or adjusted internal locus,
confounded or adjusted external locus, and for the original or adjusted SDI
or RAI overall index.
}
\examples{
## attach dataset to search path (for using variable names)
attach(learning_motivation)

## original and adjusted index summary
summary(sdi(intrinsic, identified, introjected, external, compute.adjusted = FALSE))
summary(sdi(intrinsic, identified, introjected, external))
}
\references{
Uenlue, A. (2016) Adjusting potentially confounded scoring
  protocols for motivation aggregation in organismic integration theory: An
  exemplification with the relative autonomy or self-determination index.
  \emph{Frontiers in Educational Psychology}, \bold{7}(272), 1--4. URL
  \url{https://doi.org/10.3389/fpsyg.2016.00272}.
}
\seealso{
The main function of the package, which creates objects of the class
  \code{sdi}: \code{\link{sdi}} for the original and adjusted SDI or RAI
  index. \code{\link{plot.sdi}}, the S3 method for plotting objects of the
  class \code{sdi}; \code{\link{print.sdi}}, the S3 method for printing
  objects of the class \code{sdi}. See also \code{\link{SDT-package}} for
  general information about this package.
}
\author{
Ali Uenlue <ali.uenlue@icloud.com>
}
\keyword{methods}
\keyword{univar}
