% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_gen.R
\name{order_gen}
\alias{order_gen}
\title{Generate all topological orderings}
\usage{
order_gen(omega)
}
\arguments{
\item{omega}{input p-dimensional square matrix}
}
\value{
a \eqn{p \times p!} matrix of dimension orderings. Each column
    represents an ordering of dimension names as character strings.
}
\description{
Takes a matrix and generates a matrix containing all orderings of the rows and columns
}
\examples{
data(riskcor)
orderings <- order_gen(riskcor)

# Each column of orderings defines an ordering of variables
print(orderings[,1])
# in the second element, the fifth and sixth variable are switched
print(orderings[,2])
}
\references{
\insertRef{combinat}{SEset}
}
\seealso{
\code{\link{reorder_mat}}, \code{\link{network_to_SEset}}
}
