% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_mat.R
\name{reorder_mat}
\alias{reorder_mat}
\title{Re-order rows and columns}
\usage{
reorder_mat(matrix, names)
}
\arguments{
\item{matrix}{input matrix to be re-arranged. Must have rows and columns named}

\item{names}{character vector containing the dimension names of the input matrix
in the desired ordering}
}
\value{
input matrix with rows and columns sorted according to names
}
\description{
Takes a matrix and re-orders the rows and columns to some target ordering
}
\examples{
data(riskcor)

# first define an ordered vector of names
row_names <- rownames(riskcor)
row_names_new <- row_names[c(1,2,3,4,6,5)]

reorder_mat(riskcor,row_names_new)

# The fifth and sixth row and column have been switched
print(riskcor)
}
\seealso{
\code{\link{order_gen}}, \code{\link{network_to_SEset}}
}
