% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOCDs.R
\name{MOCDs}
\alias{MOCDs}
\title{M Array Method for Optimal Covariate Designs (OCDs)}
\usage{
MOCDs(design)
}
\arguments{
\item{design}{Input a design in matrix format and block size k such that (k+1) is a prime number.}
}
\value{
Generates W matrices and Inter product sums of W matrices.
}
\description{
Consider Mutually Orthogonal Latin squares of order s x s, extract first column from it and make a new matrix called Initial block sequence matrix L of order s x s-1. Remove the last row from the L matrix and obtain the incidence matrix of it keeping zeros to the positions corresponding to the elements that were present in the deleted row of L, and then remove the row that contains only non-zero elements, the square matrix thus formed is the M matrix. From the columns of M matrix, choose((s-1),2) pairs are possible. Each of these column pairs is then superimposed to N. Through this method choose((s-1),2) W matrices can be developed.
}
\examples{
library(SFOCDs)
mat<-matrix(c(1,2,3,4,1,2,4,5,1,3,4,5,2,3,4,5),nrow=4,byrow=TRUE)
MOCDs(mat)
}
\references{
Das, K., N. K. Mandal, and B. K. Sinha. (2003) <https://doi.org/10.1016/S0378-3758(02)00151-9>. Optimal experimental designs for models with covariates. Journal of Statistical Planning and Inference 115(1): 273-285.

Bansal, N., and D. K. Garg. (2022)<https://doi.org/10.1007/s42519-022-00244-0>. Optimum covariate designs for three associate PBIB designs. Journal of Statistical Theory and Practice 16(3): 1-15.
}
\author{
Neethu RS

Cini Varghese

Mohd Harun

Anindita Datta

Ashutosh Dalal
}
