% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.target.R
\name{build.target}
\alias{build.target}
\title{Creates a covariance target, optionally by using prior information (e.g. from KEGG
pathways).}
\usage{
build.target(x, genegroups = NULL, type = "D")
}
\arguments{
\item{x}{An \eqn{n \times p} matrix.}

\item{genegroups}{List of the groups each gene belongs to: each entry of the
list is dedicated to a gene (identified the same way as in \eqn{x}). Each
item of the list is thus a vector of pathway IDs. Default value = `NULL`.}

\item{type}{Character string specifying the wished target: "D" (by default) for a
diagonal target, "cor" for a correlation target, "G", "Gpos" and "Gstar" for
a G-type target (see Jelizarow et al, 2010) and "F" for a F-target.}
}
\value{
A \eqn{p \times p} target covariance matrix of a certain
type.
}
\description{
The function `build.target()` is a wrapper function to build the various types
of covariance targets: diagonal ("D"), constant correlation ("F"), 
knowledge based ("G", "Gpos", and "Gstar"), correlation ("cor").
}
\examples{

# Simulate dataset
x <- matrix(rnorm(20*30), 20, 30)
# Try different targets
build.target(x, type = "D")

}
\references{
M. Jelizarow, V. Guillemot, A. Tenenhaus, K. Strimmer, A.-L.
Boulesteix, 2010.  Over-optimism in bioinformatics: an illustration.
Bioinformatics. Accepted.
}
\seealso{
\code{\link{targetCor}}, \code{\link{targetD}},
\code{\link{targetF}}, \code{\link{targetG}}, \code{\link{targetGpos}},
\code{\link{targetGstar}},.
}
\author{
Vincent Guillemot and Monika Jelizarow
}
\keyword{methods}
