% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additiveMatrixFitter.R
\name{additiveMatrixFitter}
\alias{additiveMatrixFitter}
\title{Additive Pattern Fitter}
\usage{
additiveMatrixFitter(mat, trainMask)
}
\arguments{
\item{mat}{Numeric matrix containing the data to fit}

\item{trainMask}{Logical matrix of same dimensions as mat, indicating which cells to use for training}
}
\value{
Numeric matrix of same dimensions as mat containing the fitted additive pattern
}
\description{
Fits an additive pattern to matrix data using training data specified by a mask.
The pattern is based on row and column main effects, creating an additive model
where each cell value is the sum of a row effect and column effect minus the overall mean.
}
\details{
The function creates an additive pattern by:
\itemize{
\item Masking non-training cells as NA to compute statistics only on training data
\item Computing overall mean of training data
\item Computing row means and column means from training data
\item Replacing non-finite means with overall mean as fallback
\item Creating additive pattern as outer sum of row and column effects minus overall mean
}
}
