% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplicativeMatrixFitter.R
\name{multiplicativeMatrixFitter}
\alias{multiplicativeMatrixFitter}
\title{Multiplicative Pattern Fitter}
\usage{
multiplicativeMatrixFitter(mat, trainMask)
}
\arguments{
\item{mat}{Numeric matrix containing the data to fit}

\item{trainMask}{Logical matrix of same dimensions as mat, indicating which cells to use for training}
}
\value{
Numeric matrix of same dimensions as mat containing the fitted multiplicative pattern
}
\description{
Fits a multiplicative pattern to matrix data using training data specified by a mask.
The pattern is based on the outer product of centered row and column effects, creating
a bilinear surface that can capture multiplicative interactions between rows and columns.
}
\details{
The function creates a multiplicative pattern by:
\itemize{
\item Computing the mean of training data as baseline
\item Creating centered row effects (0 to nRows-1, mean-centered)
\item Creating centered column effects (0 to nCols-1, mean-centered)
\item Taking outer product to form bilinear pattern
\item Fitting scaling coefficient using least squares on training data
\item Returning baseline plus scaled pattern
}
}
