% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzer_alpha_0.06.R
\name{tidal_analyzer}
\alias{tidal_analyzer}
\title{Tidal analyzer}
\usage{
tidal_analyzer(
  setdir = getwd(),
  input_name = file.choose(),
  output_name,
  starting_threshold = 0.03,
  time_frame = NA,
  out_file = TRUE
)
}
\arguments{
\item{setdir}{working directory}

\item{input_name}{csv file}

\item{output_name}{name of the output file}

\item{starting_threshold}{initial value for the dynamic threshold}

\item{time_frame}{custom data range from the time column}

\item{out_file}{flag for the export of a csv file}
}
\value{
csv containing the end tidals, their maximum, average, frequency, and timing
}
\description{
This function takes as input a csv file containing a time
column and data columns and returns the position of the end tidals for
each data column maximazing the syncronization between data. This function
was originally devised for the analysis of the end tidals coming from
exhaled breath analyzed through SIFT-MS technology
}
\examples{
data(SIFT_filtered)
tidal_analyzer(input_name = head(SIFT_filtered, n = 100), output_name = "out", out_file = FALSE)

}
