% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_cor.R
\encoding{UTF-8}
\name{beta_cor}
\alias{beta_cor}
\title{Caculate the estimator of beta on the COR}
\usage{
beta_cor(K = K, nk = nk, alpha = alpha, X = X, y = y)
}
\arguments{
\item{K}{is the number of subsets}

\item{nk}{is the length of subsets}

\item{alpha}{is the significance level}

\item{X}{is the observation matrix}

\item{y}{is the response vector}
}
\value{
A list containing:
\item{betaC}{The estimator of beta on the COR.}
}
\description{
Caculate the estimator of beta on the COR
}
\examples{
 p=6;n=1000;K=2;nk=200;alpha=0.05;sigma=1
 e=rnorm(n,0,sigma); beta=c(sort(c(runif(p,0,1))));
 data=c(rnorm(n*p,5,10));X=matrix(data, ncol=p);
 y=X\%*\%beta+e;
 beta_cor(K=K,nk=nk,alpha=alpha,X=X,y=y)
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}
}
