% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.R
\name{slide}
\alias{slide}
\title{Single Cell Linkage by Distance Estimation is SLIDE}
\usage{
slide(infected, uninfected, cutoff = 1.2)
}
\arguments{
\item{infected}{A dataframe of protein expression levels in an infected subset of cells. All columns must be numeric expression levels.}

\item{uninfected}{A dataframe of protein expression levels in uninfected cells. All columns must be numeric expression levels. This can be interpreted as the population of cells, of which the infected cells are a subset.}

\item{cutoff}{This is the fold-change in distances being tested from an infected cell to its nearest uninfected and infected cell. The default value is 1.2. Determine an exact value using the \code{bootstrap_cutoff} function.}
}
\value{
A list with containing five items. Non-parametric testing of up or downregulation in protein expression between the \code{infected} and \code{uninfected} cells, for both balanced and unbalanced comparisons. Three, it returns a boxplot mirroring these results. Four, the SLIDE Wilcox Rank Sum test results for evidence of cellular remodeling in the infected cells. Fifth, the mean ratio of the distances from each infected cell to its nearest uninfected cell and nearest infected cell.
}
\description{
Single Cell Linkage by Distance Estimation is SLIDE
}
\examples{
slide(I_sig, UN_sig)
}
\references{
Sen, N., Mukherjee, G., and Arvin, A.M. (2015). Single cell mass cytometry reveals remodeling of human T cell phenotypes by varicella zoster virus. Methods 90, 85–94.
}
