% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aopt.R
\name{Aopt}
\alias{Aopt}
\title{Calculate the A-optimal design under the second-order Least squares estimator}
\usage{
Aopt(N, u, tt, FUN, theta, num_iter = 1000)
}
\arguments{
\item{N}{The number of sample points in the design space.}

\item{u}{The discretized design space.}

\item{tt}{The level of skewness between 0 to 1 (inclusive). When tt=0, it is equivalent to compute the A-optimal design under the ordinary least squares estimator.}

\item{FUN}{The function to calculate the derivative of the given model.}

\item{theta}{The parameter value of the model.}

\item{num_iter}{Maximum number of iteration.}
}
\value{
A list that contains 1. Value of the objective function at solution. 2. Status. 3. Optimal design
}
\description{
Calculate the A-optimal design under the second-order Least squares estimator
}
\details{
This function calculates the A-optimal design and the loss function under the A-optimality. The loss function under A-optimality is defined as the trace of the inverse of the Fisher information matrix
}
\examples{
poly3 <- function(xi, theta){
  matrix(c(1, xi, xi^2, xi^3), ncol = 1)
}
Npt <- 101
my_design <- Aopt(N = Npt, u = seq(-1, +1, length.out = Npt),
   tt = 0, FUN = poly3, theta = rep(0,4), num_iter = 2000)
round(my_design$design, 3)
my_design$val
}
