# objective: Test that hammingloss
# implemented in {SLmetrics} is aligned with
# target functions.

testthat::test_that(
  desc = "Test `hammingloss()`-function", code = {

    testthat::skip_on_cran()

    # 0) construct Balanced hammingloss
    # wrapper
    wrapped_hammingloss <- function(
      actual,
      predicted,
      w = NULL) {
        if (is.null(w)) {
          hammingloss(
            actual     = actual,
            predicted  = predicted
          )
        } else {
          weighted.hammingloss(
            actual     = actual,
            predicted  = predicted,
            w          = w
          )
        }
      }
    
    for (balanced in c(FALSE, TRUE)) {

      # 1) generate class
      # values
      actual    <- create_factor(balanced = balanced)
      predicted <- create_factor(balanced = balanced)
      w         <- runif(n = length(actual))

      for (weighted in c(TRUE, FALSE)) {
      
        # 2.1) generate sensible 
        # label information
        info <- paste(
          "Balanced = ", balanced,
          "Weighted = ", weighted
        )

        # 2.2) generate score
        # from {SLmetrics}
        score <- wrapped_hammingloss(
          actual     = actual,
          predicted  = predicted,
          w          = if (weighted) w else NULL
        )

        # 2.3) test that the values
        # are sensible the values 
        # can be NA
        testthat::expect_true(is.numeric(score), info = info)
        testthat::expect_true(length(score) == 1, info = info)

        # 2.4) test that the values
        # are equal to target value

        # 2.4.1) calculate py_score
        py_score <- py_hammingloss(
          actual    = actual,
          predicted = predicted,
          w          = if (weighted) w else NULL
        )

        # 2.4.2) test for equality
        testthat::expect_true(
          object = set_equal(
            current = as.numeric(score),
            target  = as.numeric(py_score)
          ),
          info = info
        )

      }

    }
  }
)