% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepThree.R
\name{StepThree}
\alias{StepThree}
\title{Post-hoc model}
\usage{
StepThree(X, M, C, time, status, X_sel_Y_s1, M_X_sel_s2)
}
\arguments{
\item{X}{An n by p matrix of exposures.}

\item{M}{An n by p matrix of mediators.}

\item{C}{An n by p matrix of covariates. If there are no covariates, set C = NULL.}

\item{time}{A vector of survival time of samples.}

\item{status}{A vector of status indicator: 0=alive, 1=dead.}

\item{X_sel_Y_s1}{Outputs from StepOne: A vector of selected X for Y.}

\item{M_X_sel_s2}{Outputs from StepTwo: A data table with selected M, X pairs and related effect size.}
}
\value{
A list with the following components:
\item{p_beta_m}{p-values generated from outcome model}
\item{p_alpha_x}{p-values generated from mediation modell}
\item{outcome_model}{coefficient estimates from outcome model}
\item{med_results}{coefficient estimates from mediation model}
}
\description{
An auxiliary function which generates p-value based on outcome and mediation model.
}
\examples{
\donttest{
data(example_dat)
surv_dat <- example_dat$surv_dat
res_step1 <- StepOne(X = example_dat$X, M = example_dat$M, time = surv_dat$time,
status = surv_dat$status, model_option = "MCP")
M_X_sel_s2 <- StepTwo(X = example_dat$X, M = example_dat$M, time = surv_dat$time,
status = surv_dat$status, X_sel_Y_s1 = res_step1$X_sel_Y_s1, M_X_s1 = res_step1$M_X_s1,
M_sel_Y_s1 = res_step1$M_sel_Y_s1)
res_step3 <- StepThree(X = example_dat$X, M = example_dat$M, C = example_dat$C,
time = surv_dat$time, status = surv_dat$status, X_sel_Y_s1 = res_step1$X_sel_Y_s1,
M_X_sel_s2 = M_X_sel_s2)
}
}
