% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Captopril.R
\docType{data}
\name{Captopril}
\alias{Captopril}
\title{Captopril effectiveness}
\format{
A data frame with 30 rows (one per person) and 3 columns:
\describe{
  \item{Before}{The blood pressure before taking captopril, in mm Hg}
  \item{After}{The blood pressure after taking captopril, in mm Hg}
  \item{BP}{The type of blood pressure measured; \code{S} for systolic, and \code{D} for diastolic}
}
}
\source{
D. J. Hand, F. Daly, A. D. Lunn, K. J. McConway, and E. Ostrowski (1994) 
A Handbook of Small Data Sets, London: Chapman and Hall. Dataset 72.
}
\usage{
data(Captopril)
}
\description{
Blood pressure before and after treatment with Captopril.
}
\examples{
plot( After ~ Before, data = subset(Captopril, BP=="S"), xlab = "Before SBP", ylab = "After SBP")

}
\references{
MacGregor, Graham A., N. D.Markandu, J. E. Roulston, and J. C. Jones. 1979. 
Essential Hypertension: Effect of an Oral Inhibitor of 
Angiotensin-Converting Enzyme.
\emph{British Medical Journal} \bold{2}: 1106--1109.
}
\keyword{datasets}
