% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mandible.R
\docType{data}
\name{Mandible}
\alias{Mandible}
\title{Mandible lengths}
\format{
A data frame with 167 rows (each foetus) and 2 columns:
\describe{
  \item{Age}{The foetus age, in weeks}
  \item{Length}{The mandible length, in mm}
}
}
\source{
Patrick Royston and Douglas G. Altman (1994).
Regression using fractional polynomials of continuous covariates: 
Parsimonious parametric modelling. 
\emph{Applied Statistics}, \bold{43}(3), 429--467.
}
\usage{
data(Mandible)
}
\description{
The mandible length and gestational age for 167 foetuses from the 
12th week of gestation onwards
}
\examples{
plot(Length ~ Age, data = Mandible, xlab = "Age (weeks)", ylab = "Mandible length (mm)")

}
\keyword{datasets}
