% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_revisions.R
\name{od_revisions}
\alias{od_revisions}
\title{Get OGD revisions}
\usage{
od_revisions(since = NULL, exclude_ext = TRUE, server = "ext")
}
\arguments{
\item{since}{(optional) A timestamp. If supplied, only datasets updated
later will be returned. Otherwise, all datasets are returned.
Can be in either one of the following formats
\itemize{
\item a native R time type that is compatible with \code{strftime()}
such as the return values of \code{Sys.Date()}, \code{Sys.time()} and \code{file.mtime()}.
\item a string of the form \code{YYYY-MM-DD} to specify a day.
\item a string of the form \code{YYYY-MM-DDThh:mm:ss} to specify a day and a time.
}}

\item{exclude_ext}{If \code{TRUE} (default) exclude all results that have
\code{OGDEXT_} as a prefix}

\item{server}{the open data server to use. Either \code{ext} for the external
server (the default) or \code{red} for the editing server. The editing server
is only accessible for employees of Statistics Austria}
}
\value{
a character vector with dataset ids
}
\description{
Use the \verb{/revision} endpoint of the OGD server to get a list
of all datasets that have changed since a certain timestamp.
}
\examples{
# get all datasets (including OGDEXT_*)
ids <- od_revisions(exclude_ext = FALSE)
ids
sample(ids, 6)

# get all the datasets since the fifteenth of august
od_revisions("2022-09-15")
}
