% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_HARA_RM.R
\name{stress_HARA_RM_w}
\alias{stress_HARA_RM_w}
\title{Stressing Risk Measure and HARA Utility}
\usage{
stress_HARA_RM_w(
  x,
  alpha = 0.8,
  a,
  b,
  eta,
  q_ratio = NULL,
  q = NULL,
  hu_ratio = NULL,
  hu = NULL,
  k = 1,
  h = 1,
  gamma = NULL,
  names = NULL,
  log = FALSE,
  method = "Nelder-Mead"
)
}
\arguments{
\item{x}{A vector, matrix or data frame
containing realisations of random variables. Columns of \code{x}
correspond to random variables; OR\cr
A \code{SWIMw} object, where \code{x} corresponds to the
underlying data of the \code{SWIMw} object. The stressed random component is assumed continuously distributed.}

\item{alpha}{Numeric, vector, the level of the Expected Shortfall. (\code{default Expected Shortfall})\cr}

\item{a}{Numeric vector, input to HARA utility function.\cr}

\item{b}{Numeric vector, input to HARA utility function.\cr}

\item{eta}{Numeric vector, input to HARA utility function.\cr}

\item{q_ratio}{Numeric, vector, the ratio of the stressed RM to
the baseline RM (must be same length as \code{alpha}).\cr}

\item{q}{Numeric, vector, the stressed RM at level
\code{alpha} (must be same length as \code{alpha}).\cr}

\item{hu_ratio}{Numeric, vector, the ratio of the HARA utility to the 
baseline HARA utility.\cr}

\item{hu}{Numeric, vector, the stressed HARA utility with parameters
\code{a}, \code{b} and \code{eta}.\cr}

\item{k}{Numeric, the column of \code{x} that is stressed
\code{(default = 1)}.\cr}

\item{h}{Numeric, a multiplier of the default bandwidth using Silverman’s rule (default \code{h = 1}).\cr}

\item{gamma}{Function of one variable, that defined the gamma of the risk measure. (\code{default Expected Shortfall}).\cr}

\item{names}{Character vector, the names of stressed models.}

\item{log}{Boolean, the option to print weights' statistics.}

\item{method}{The method to be used in [stats::optim()]. (\code{default = Nelder-Mead}).}
}
\value{
A \code{SWIMw} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{h}, h is a multiple of the Silverman’s rule;
      \item \code{u}, vector containing the gridspace on [0, 1];
      \item \code{lam}, vector containing the lambda's of the optimized model;
      \item \code{str_fY}, function defining the densities of the stressed component;
      \item \code{str_FY}, function defining the distribution of the stressed component;
      \item \code{str_FY_inv}, function defining the quantiles of the stressed component;
      \item \code{gamma}, function defining the risk measure;
      \item \code{new_weights}, a list of functions, that applied to
  the \code{k}th column of \code{x}, generates the vectors of scenario
  weights. Each component corresponds to a different stress;
     \item \code{type = "HARA RM"};
     \item \code{specs}, a list, each component corresponds to
   a different stress and contains \code{k}, \code{alpha}, \code{a}, \code{b},
   \code{eta}, \code{q}, and \code{hu}.
    }
    See \code{\link{SWIM}} for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that a stressed model component (random variable) fulfills a
    constraint on its HARA utility defined by \code{a}, \code{b} and 
    \code{eta} parameter and risk measure defined by a \code{gamma} 
    function and evaluated at a given level \code{alpha}. Scenario weights are
    selected by constrained minimisation of the Wasserstein distance to the
    baseline model.
}
\details{
This function implements stresses on distortion risk measures.
    Distortion risk measures are defined by a square-integrable function
    \code{gamma} where
    \deqn{\int_0^1 gamma(u) du = 1.}
    
    The distortion risk measure for some \code{gamma} and distribution 
    \code{G} is calculated as:
    \deqn{\rho_{gamma}(G) = \int_0^1 \breve(G)(u) gamma(u) du.}

    Expected Shortfall (ES) is an example of a distortion risk measure.
    The ES at level \code{alpha} of a random variable with distribution
    function F is defined by:
    \deqn{ES_{alpha} = 1 / (1 - alpha) * \int_{alpha}^1 VaR_u d u.}

    The HARA Utility is defined by 
    \deqn{u(x) = \frac{1-eta}{eta}(\frac{ax}{1 - eta} + b)^eta}.
}
\examples{
\dontrun{
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000),
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress_wass(type = "HARA RM", x = x, a=1, b=5, eta=0.5, alpha=0.95,
 q_ratio=1.05, hu_ratio=1.05, k=1)
  summary(res1)

## calling stress_RM_w directly
## stressing "gamma"
res2 <- stress_HARA_RM_w(x = x, a=1, b=5, eta=0.5, alpha=0.95,
 q_ratio=1.05, hu_ratio=1.05, k=2)
summary(res2)
}

}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Pesenti2020SSRN}{SWIM}\cr

    \insertRef{Pesenti2021SSRN}{SWIM}
}
\seealso{
Other stress functions: 
\code{\link{stress_RM_mean_sd_w}()},
\code{\link{stress_RM_w}()},
\code{\link{stress_VaR_ES}()},
\code{\link{stress_VaR}()},
\code{\link{stress_mean_sd_w}()},
\code{\link{stress_mean_sd}()},
\code{\link{stress_mean_w}()},
\code{\link{stress_mean}()},
\code{\link{stress_moment}()},
\code{\link{stress_prob}()},
\code{\link{stress_user}()},
\code{\link{stress_wass}()},
\code{\link{stress}()}
}
\author{
Zhuomin Mao
}
\concept{stress functions}
