% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getRadarWaveLength}
\alias{seasonder_getRadarWaveLength}
\title{Calculate the Radar Wavelength}
\usage{
seasonder_getRadarWaveLength(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing metadata about
the radar system, including its center frequency.}
}
\value{
A numeric value representing the radar wavelength in meters (m).
}
\description{
This function computes the radar wavelength based on the center frequency
of the SeaSonde radar system. The wavelength is derived using the speed of
light and the radar's center frequency.
}
\details{
The radar wavelength \eqn{\lambda} is calculated using the formula:
\eqn{\lambda = \frac{c}{f}}
where:
\itemize{
\item \eqn{c} is the speed of light (approximately \eqn{3 * 10^8} m/s),
\item \eqn{f} is the radar's center frequency in Hz, retrieved from the SeaSondeRCS object.
}

The center frequency is initially stored in MHz and is converted to Hz by multiplying
it by \eqn{10^6}.
}
\seealso{
\code{\link{seasonder_getCenterFreqMHz}} to retrieve the radar's center frequency.
}
