% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_setSeaSondeRCS_MUSIC}
\alias{seasonder_setSeaSondeRCS_MUSIC}
\title{Set MUSIC Data in a SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_MUSIC(seasonder_cs_object, MUSIC)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing cross-spectral data and metadata.}

\item{MUSIC}{A data structure containing the MUSIC algorithm results. This is typically a list or tibble
produced during the MUSIC processing workflow.}
}
\value{
The updated \code{SeaSondeRCS} object with the specified MUSIC data stored in its attributes.
}
\description{
This function assigns MUSIC analysis results to a SeaSondeRCS object. The MUSIC data is stored
within the object's \code{MUSIC_data} attribute under the field \code{MUSIC}. Currently, no explicit
validation is performed on the provided MUSIC data.
}
\details{
This low-level setter function updates the SeaSondeRCS object's MUSIC data by assigning the provided
MUSIC results to the \code{MUSIC} field within the \code{MUSIC_data} attribute. It is intended for use
during the MUSIC processing workflow.
}
