% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_validateFORMethod}
\alias{seasonder_validateFORMethod}
\title{Validate First Order Region (FOR) Processing Method}
\usage{
seasonder_validateFORMethod(method)
}
\arguments{
\item{method}{A character string specifying the FOR processing method. Currently, only \code{"SeaSonde"} is supported.}
}
\value{
The function returns the input \code{method} invisibly if it is valid.
}
\description{
This function checks whether the specified method for First Order Region (FOR) detection
is supported. If an unsupported method is provided, it logs an error and aborts execution.
}
\details{
The function verifies that the \code{method} argument is valid. If the method is not recognized,
an error is raised using \code{\link{seasonder_logAndAbort}}.

\strong{Supported Methods:}
\itemize{
\item \code{"SeaSonde"}: Implements first-order region detection based on CODAR's SeaSonde methodology.
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_validateFOR_parameters}} for FOR parameter validation.
\item \code{\link{seasonder_logAndAbort}} for error handling and logging.
}
}
