% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_select_glmnet_beta.R
\name{betareg_glmnet}
\alias{betareg_glmnet}
\title{Pure glmnet IRLS selector for Beta regression}
\usage{
betareg_glmnet(
  X,
  Y,
  alpha = 1,
  choose = c("bic", "aic", "cv"),
  nfolds = 5,
  n_iter = 6,
  tol = 1e-05,
  standardize = TRUE,
  lambda = NULL,
  phi_init = 20,
  update_phi = TRUE,
  phi_maxit = 5,
  prestandardize = FALSE,
  trace = FALSE
)
}
\arguments{
\item{X}{Numeric matrix (n × p) of mean-submodel predictors.}

\item{Y}{Numeric response in (0,1). Values are squeezed to (0,1) internally.}

\item{alpha}{Elastic-net mixing parameter.}

\item{choose}{One of \code{"bic"}, \code{"aic"}, or \code{"cv"} to pick \code{lambda}.}

\item{nfolds}{Folds for CV when \code{choose = "cv"}.}

\item{n_iter}{Max IRLS iterations;}

\item{tol}{Convergence tolerance for the IRLS parameter change (Euclidean norm
of the difference in \verb{[a0, beta]}), default \code{1e-5}.}

\item{standardize}{Forwarded to \code{glmnet} (ignored if \code{prestandardize = TRUE}).}

\item{lambda}{Optional fixed lambda; if \code{NULL}, chosen by \code{choose}.}

\item{phi_init}{Initial precision (phi).}

\item{update_phi}{Logical; update phi inside the IRLS loop.}

\item{phi_maxit}{Newton steps for phi update.}

\item{prestandardize}{If \code{TRUE}, manually center/scale \code{X} once and
disable \code{glmnet}'s internal standardization (speed trick).}

\item{trace}{Logical; print IRLS progress.}
}
\value{
Named numeric vector \code{(Intercept)} + \code{colnames(X)} with zeros for
unselected variables.
}
\description{
Runs an IRLS loop with Beta working responses/weights and calls
\code{glmnet} on the weighted least-squares surrogate. Supports BIC/AIC/CV
model choice and an optional \code{prestandardize} speedup. The helper uses only
the mean submodel, requires complete cases, and does not expose offset terms.
}
\examples{
set.seed(1); X <- matrix(rnorm(500), 100, 5); Y <- plogis(X[,1]-0.5*X[,3])
Y <- rbeta(100, Y*40, (1-Y)*40)
betareg_glmnet(X, Y, alpha = 1, choose = "bic", prestandardize = TRUE)
}
\seealso{
\code{\link[glmnet:glmnet]{glmnet::glmnet()}}, \code{\link[glmnet:cv.glmnet]{glmnet::cv.glmnet()}}
}
