% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estsh.R
\name{est.shstrrs}
\alias{est.shstrrs}
\title{Estimating the Shapley value based on structured simple random sampling (StrRS)}
\usage{
est.shstrrs(d, n, val, ...)
}
\arguments{
\item{d}{an integer, the number of players.}

\item{n}{an integer, the sample size.}

\item{val}{the predefined value function.}

\item{...}{other parameters used in val(sets,...).}
}
\value{
a vector including estimated Shapley values of all players based on StrRS.
}
\description{
Estimating the Shapley value based on structured simple random sampling (StrRS)
}
\examples{
temp_adjacent<-matrix(0,nrow=8,ncol=8)
temp_adjacent[1,6:8]<-1;temp_adjacent[2,7]<-1;temp_adjacent[c(4,6,7),8]<-1;
temp_adjacent<-temp_adjacent+t(temp_adjacent)
temp_val<-function(sets,adjacent){
  if(length(sets)==1) val<-0
  else{
    subadjacent<-adjacent[sets,sets]
    nsets<-length(sets)
    A<-diag(1,nsets); B<-matrix(0,nsets,nsets)
    for(l in 1:(nsets-1)){
      A<-A\%*\%subadjacent
      B<-B+A
    }
    val<-ifelse(sum(B==0)>nsets,0,1)
  }
  return(val)
}
est.shstrrs(8,112,temp_val,temp_adjacent)
}
