% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShiVa.R
\name{soft_thresholding}
\alias{soft_thresholding}
\title{Soft Thresholding}
\usage{
soft_thresholding(z, lambda)
}
\arguments{
\item{z}{A numeric value to be thresholded.}

\item{lambda}{A non-negative numeric value indicating the threshold level (degree of shrinkage).}
}
\value{
A numeric value after applying soft thresholding:
\eqn{\text{sign}(z) \cdot \max(|z| - \lambda, 0)}.
}
\description{
Applies the soft thresholding operation to a numeric input, commonly used in Lasso and sparse modeling to induce shrinkage and sparsity.
}
