#' Simulated Correlation Parameters
#'
#' A simulated dataset to explore the association between the correlation
#' parameter of bivariate normally distributed random variables used in the
#' intermediate step of the NORTA method and the correlation parameter of the
#' resulting non-normal random responses generated by the NORTA method for all
#' the threshold approached implemented in this package.
#'
#' @format
#' A data frame with 100 rows and 4 columns:
#' \describe{
#'   \item{rho}{numeric indicating the true value of the correlation parameter.}
#'   \item{normal}{numeric indicating the simulated correlation parameter when
#'   the marginal distribution of each of the latent variables is normal.}
#'   \item{logistic}{numeric indicating the simulated correlation parameter
#'   when the marginal distribution of each of the latent variables is
#'   logistic.}
#'   \item{gumbel}{numeric indicating the simulated correlation parameter when
#'   the marginal distribution of each of the latent variables is Gumbel.}
#' }
#' @examples
#' plot(rho - normal ~ rho, data = simulation, type = "l", col = "blue",
#'     ylim = c(0, 0.016),
#'     ylab = expression(rho - bar(rho)[sim]),
#'     xlab = expression(rho))
#' points(rho - logistic ~ rho, data = simulation, type = "l", col = "red")
#' points(rho - gumbel ~ rho, data = simulation, type = "l", col = "grey")
#' legend("topright", legend = c("Normal", "Logistic", "Gumbel"),
#'       col = c("blue", "red", "grey"), pch = "l" )
"simulation"

