% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{sim_reg}
\alias{sim_reg}
\title{Similarity regression}
\usage{
sim_reg(
  ontology,
  x,
  y,
  information_content = get_term_info_content(ontology, x),
  sim_params = list(ontology = ontology, information_content = information_content),
  using_terms = get_terms(sim_params),
  term_weights = rep(0, length(using_terms)),
  prior = discrete_gamma(using_terms),
  min_BF = -Inf,
  max_select = 2000L,
  max_phi_count = 200L,
  two_way = TRUE,
  selection_fn = fg_step_tab(N = length(y)),
  lik_method = NULL,
  lik_method_args = list(),
  gamma0_ml = bg_rate,
  min_ratio = 1e-04,
  ...
)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{x}{\code{list} of \code{character} vectors of ontological terms.}

\item{y}{\code{logical} response vector.}

\item{information_content}{Numeric vector of information contents of terms named by term ID. Defaults to information content based on frequencies of annotation in \code{x}.}

\item{sim_params}{List of arguments to pass to \code{get_asym_sim_grid}.}

\item{using_terms}{Character vector of term IDs giving the complete set of terms to include in the the \code{phi} parameter space.}

\item{term_weights}{Numeric vector of prior weights for individual terms.}

\item{prior}{Function for computing the unweighted prior probability of a \code{phi} value.}

\item{min_BF}{Bayes factor threshold below which to terminate computation, enabling faster execution time at the expense of accuracy and precision.}

\item{max_select}{Upper bound for number of \code{phi} values to sample.}

\item{max_phi_count}{Upper bound for number of \code{phi} values to include in final likelihood sum.}

\item{two_way}{Boolean value determining whether to calculate semantic similarity `in both directions' (i.e. compute \code{s_x} and \code{s_phi} or just \code{s_phi}).}

\item{selection_fn}{Function for selecting values of \code{phi} with high posterior mass.}

\item{lik_method}{Function for calculating marginal likelihood contional on values of \code{phi}.}

\item{lik_method_args}{List of additional arguments to pass to \code{lik_method}.}

\item{gamma0_ml}{Function for computing marginal likelihood of data under baseline model \code{gamma=0}.}

\item{min_ratio}{Lower bound on ratio below which to discard \code{phi} values.}

\item{...}{Additional arguments to pass to \code{selection_fn}.}
}
\description{
Performs Bayesian `similarity regression' on given \code{logical} response vector \code{y} against \code{list} of ontological term sets \code{x}. It returns an object of class \code{sim_reg_output}. Of particular interest are the probability of an association, which can be calculated with \code{\link{prob_association}}, and the characteristic ontological profile phi, which can be visualised using the functions \code{\link{plot_term_marginals}}, and \code{\link{term_marginals}}). The results can be summarised with \code{summary}.
}
