% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Betti.R
\name{betti_number}
\alias{betti_number}
\title{Safely compute the rank of a sparse matrix}
\usage{
betti_number(simplices, bound_dim, tol = NULL)
}
\arguments{
\item{simplices}{A list of simplices representing the simplicial complex.}

\item{bound_dim}{The dimension of the boundary to compute the Betti number for.}

\item{tol}{Optional numerical tolerance to pass to \code{rankMatrix()}.}
}
\value{
An integer representing the rank of the matrix.
}
\description{
This helper function wraps \code{Matrix::rankMatrix()} to safely handle empty matrices (i.e., with 0 rows or columns).
}
\examples{
simplices <- list(c(1, 2), c(3, 4), c(2, 1, 3), c(4, 2))
betti_number(simplices, 0, tol=0.1)
}
\keyword{internal}
