% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_Timeseries.R
\docType{class}
\name{Timeseries-class}
\alias{Timeseries-class}
\title{S4 class \code{Timeseries}}
\description{
Objects of class \code{Timeseries} are used to store information for the Time Series plots.
Like all S4 objects in \code{Slick}, slots in this object can be accessed and
assigned using functions corresponding to slot name. See \code{\link[=Timeseries]{Timeseries()}} and the
the \verb{See Also} section below.
}
\details{
Objects of class \code{Timeseries} are created with \code{Timeseries()}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in \code{Value}
}
}
\section{Slots}{

\describe{
\item{\code{Code}}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Label}}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Description}}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{\code{Time}}{A numeric vector with values for the historical and projection time-steps. Must
match length \code{nTS} in \code{Value}. Can also be class \code{Date}, \code{POSIXct} or \code{POSIXt}}

\item{\code{TimeNow}}{A numeric value matching the last historical timestep in \code{Time}}

\item{\code{TimeLab}}{Character string length 1. Name of the time step (e.g., 'Year'). Will be used as the label in the plots.
Use a named list for multiple languages.}

\item{\code{Value}}{A numeric array with the stochastic performance indicator values for each
simulation (sim), operating model (OM), management procedure (MP),  performance indicator (PI),
and historical + projection timestep (nTS).
Dimensions: c(\code{nsim}, \code{nOM}, \code{nMP}, \code{nPI}, \code{nTS})}

\item{\code{Preset}}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{\code{Target}}{Numeric vector length \code{nPI} with the target value for the PIs.}

\item{\code{Limit}}{Numeric vector length \code{nPI} with the limit value for the PIs.}

\item{\code{RefPoints}}{List for setting custom Reference Points. Overrides \code{Target} and \code{Limit}.
See \code{Details} section in \code{\link[=Timeseries]{Timeseries()}}.}
}}

\examples{
# Generate dummy values
nsim <- 10
nOM <- 2
nMP <- 4
nPI <- 3
nHistTS <- 50
nProjTS <- 30
nTS <- nHistTS + nProjTS

set.seed(101)

values <- array(NA, dim=c(nsim, nOM, nMP, nPI, nTS))

pi_means <- c(1,1, 1000)

for (om in 1:nOM) {
  for (pi in 1:nPI) {
    # PI identical for historical
    histVals <- matrix(
      pi_means[pi] *
        cumprod(c(rlnorm(nHistTS*nsim, 0, 0.05))),
      nrow=nsim, ncol=nHistTS, byrow=TRUE)
    histVals <- replicate(nMP, histVals)
    values[,om, , pi,1:nHistTS] <- aperm(histVals, c(1,3,2))

    for (mp in 1:nMP) {
      values[,om, mp, pi,(nHistTS+1):nTS] <- matrix(
        pi_means[pi] *
          cumprod(c(rlnorm(nProjTS*nsim, 0, 0.05))),
        nrow=nsim, ncol=nProjTS, byrow=FALSE)
    }
  }
}

# Create and populate Object
timeseries <- Timeseries(Code=c('B/BMSY', 'F/FMSY', 'TAC'),
                         Label=c('B/BMSY',
                                 'F/FMSY',
                                 'TAC'),
                         Description = c('This is the description for PI 1',
                                         'This is the description for PI 2',
                                         'This is the description for PI 3'),
                         Value=values
)

# Last historical time step
TimeNow(timeseries) <- 2024

# Add values for time steps
Time(timeseries) <- c(rev(seq(TimeNow(timeseries), by=-1, length.out=nHistTS)),
                      seq(TimeNow(timeseries)+1, by=1, length.out=nProjTS))

# Check
Check(timeseries)

# Add to `Slick` object
slick <- Slick()
Timeseries(slick) <- timeseries

# Plots
plotTimeseries(slick)
plotTimeseries(slick, 2)
plotTimeseries(slick, 3)

plotTimeseries(slick, byMP=TRUE)

plotTimeseries(slick, byOM=TRUE)

# Custom Reference Points
RefPoints(timeseries) <- list(
  list(Name=c('0.5 BMSY', 'BMSY', '1.5 BMSY'),
       Value=c(0.5, 1, 1.5),
       Color=c('red', 'orange', 'green')),
  list(Name=c('0.8 FMSY', 'FMSY'),
       Value=c(0.8,1),
       Color=c('orange', 'red')),
  list(Name='Target Catch',
       Value=1200,
       Color='blue')
)

Timeseries(slick) <- timeseries
plotTimeseries(slick)
plotTimeseries(slick, 2)
plotTimeseries(slick, 3)


}
\seealso{
\code{\link[=Timeseries]{Timeseries()}}, \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}},
\code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}}
}
