% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseFunClust.R
\name{SparseFunClust}
\alias{SparseFunClust}
\title{Compute Sparse Functional Clustering & Alignment}
\usage{
SparseFunClust(
  data,
  x,
  K,
  do.alignment,
  funct.measure = "L2",
  clust.method = "kmea",
  m.prop = 0.3,
  tuning.m = FALSE,
  tuning.par = list(mbound = NULL, nperm = 20),
  perc = 0.03,
  tol = 0.01,
  template.est = "raw",
  n.out = 500,
  iter.max = 50,
  vignette = TRUE
)
}
\arguments{
\item{data}{matrix representing the functions (n x p)}

\item{x}{matrix giving the domain of each function (n x p), or a
p-dimensional vector giving the common domain}

\item{K}{number of clusters}

\item{do.alignment}{boolean (should alignment be performed?)}

\item{funct.measure}{the functional measure to be used to compare the
functions in both the clustering and alignment procedures;
can be 'L2' or 'H1' (default 'L2'); see Vitelli (2019) for details}

\item{clust.method}{the clustering method to be used; can be:
'kmea' for k-means clustering,'pam','hier' for hierarchical clustering}

\item{m.prop}{the sparsity parameter (proportion of unrelevant domain
where w(x) = 0); default 30\%}

\item{tuning.m}{boolean (should the sparsity parameter be tuned via a
permutation-based approach?)}

\item{tuning.par}{list of settings for the tuning of the sparsity parameter
(defaults to \code{list(mbound = NULL, nperm = 20)}: mbound = max value of
the sparsity parameter to be tested, default 60\%; nperm = number of
permutations to be performed in the tuning, default 20}

\item{perc}{alignment parameter (max proportion of shift / dilation at each iter
of the warping procedure) --> (default 3\%)}

\item{tol}{tolerance criterion on the weighting function to exit the loop (default 1\%)}

\item{template.est}{text string giving choices for the template estimation method}

\item{n.out}{number of abscissa points on which w(x) is estimated (default 500)}

\item{iter.max}{maximum number of iterations of the clustering loop (default 50)}

\item{vignette}{boolean (should the algorithm progress be reported?)}
}
\value{
A list, with elements:
\describe{
\item{template}{matrix (dim=K x n.out) with the final cluster templates}
\item{temp.abscissa}{vector (length=n.out) of the abscissa values on which the template is defined}
\item{labels}{vector (length=n) of the cluster assignments}
\item{warping}{matrix (dim=n x 2) with the intercept (1st column) and slope (2nd column)
of the estimated warping function for each of the n curves}
\item{reg.abscissa}{matrix (dim=n x n.out) of each of the n curves registered abscissa}
\item{distance}{vector (length=n) of each curve's final distance to the assigned cluster template}
\item{w}{vector (length=n.out) of the estimated weighting function w(x)}
\item{x.bcss}{vector (length=n.out) of the final point-wise between-cluster sum-of-squares}
}
}
\description{
Compute Sparse Functional Clustering & Alignment
}
\note{
\code{data}:
\enumerate{
\item assumed to be a vectorized version of the functional data AFTER smoothing
\item when using the H1 functional measure, assumed to include the
functions FIRST DERIVATIVES
\item when using the H1 functional measure, it supports multidimensional
functions R -> R^d, then data can be an array (n x p x d)]
}

\code{funct.measure}: 'H1' only supported with alignment

\code{clust.method}: 'pam' and 'hier' only supported for the case of
NO ALIGNMENT

\code{m.prop}: needs to be a proportion for compatibility with alignment,
values > 1 not supported

\code{tuning.m}: tuning only supported for the case of NO ALIGNMENT

\code{tuning.par}:
\itemize{
\item \code{mbound} must be lower than 1; the minimal value tested is 0
\item \code{nperm} > 50 is unadvisable for computational reasons
}

\code{perc}: 5\% is already extreme; don't set this above 8-10\%

\code{template.est}:
\enumerate{
\item only supported with H1 measure + ALIGNMENT
\item currently 2 choices are supported:'raw' or 'loess'. 'raw' just
computes the vector means across functions (default choice); 'loess'
estimates the template via the R loess function
}
}
\examples{
set.seed(8988327)
x <- seq(0, 1, len = 500)
out <- generate.data.FV17(50, x)
result <- SparseFunClust(out$data, x, K = 2, do.alignment = FALSE)
str(result)
}
