% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneill_leibovici_entropy.R
\name{contagion}
\alias{contagion}
\title{Li and Reynolds' relative contagion index.}
\usage{
contagion(
  data,
  win = spatstat.geom::owin(xrange = c(0, ncol(data)), yrange = c(0, nrow(data))),
  plotout = T
)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...}

\item{win}{Optional, an object of class \code{owin}, the observation window for data plotting}

\item{plotout}{Logical. Default to \code{TRUE}, produces an informative plot as part of the function output.}
}
\value{
a list of two elements:
\itemize{
\item \code{contagion} Li and Reynold's relative contagion index
\item \code{probabilities} a table with absolute frequencies and estimated probabilities (relative frequencies) for all couple categories
}
Moreover, a plot of the dataset is produced.
}
\description{
This function computes Li and Reynold's contagion index, following Li and Reynolds (1993),
starting from a data matrix. References can be found at \code{SpatEntropy}.
}
\details{
This index is based on the transformed variable \eqn{Z} identifying couples of realizations
of the variable of interest. A distance of interest is fixed: the contagion index is
originally thought for areas sharing a border, as O'Neill's entropy. Then, all contiguous couples
of realizations of the variable of interest are counted
and their relative frequencies are used to compute the index, which is \eqn{1-NO} where \eqn{NO}
is the relative version of O'Neill's entropy, i.e. O'Neill's entropy divided by its maximum \eqn{\log(I^2)},
\eqn{I} being the number of categories of the variable under study. The relative contagion index ranges
from 0 (no contagion, maximum entropy) to 1 (maximum contagion).
The function is able to work with grids containing missing data, specified as NA values.
All NAs are ignored in the computation and only couples of non-NA observations are considered.
}
\examples{
#numeric data, square grid
data=matrix(sample(1:5, 100, replace=TRUE), nrow=10)
contagion(data)
#plot data
plot(as.im(data, W=square(nrow(data))),
     col=grDevices::gray(seq(1,0,length.out=length(unique(c(data))))),
     main="", ribbon=TRUE)

#character data, rectangular grid
data=matrix(sample(c("a","b","c"), 300, replace=TRUE), nrow=30)
contagion(data)
#plot data
plot(as.im(data, W=owin(xrange=c(0,ncol(data)), yrange=c(0,nrow(data)))),
     col=terrain.colors(length(unique(c(data)))),
     main="", ribbon=TRUE)

}
