% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneill_leibovici_entropy.R
\name{oneill}
\alias{oneill}
\title{O'Neill's entropy.}
\usage{
oneill(
  data,
  win = spatstat.geom::owin(xrange = c(0, ncol(data)), yrange = c(0, nrow(data))),
  plotout = T
)
}
\arguments{
\item{data}{A data matrix, can be numeric, factor, character, ...}

\item{win}{Optional, an object of class \code{owin}, the observation window for data plotting}

\item{plotout}{Logical. Default to \code{TRUE}, produces an informative plot as part of the function output.}
}
\value{
a list of four elements:
\itemize{
\item \code{oneill} O'Neill's entropy
\item \code{range} the theoretical range of O'Neill's entropy, from 0 to \eqn{\log(I^2)}
\item\code{rel.oneill} O'Neill's relative entropy
\item \code{probabilities} a table with absolute frequencies and estimated probabilities (relative frequencies) for all couple categories
}
Moreover, a plot of the dataset is produced.
}
\description{
This function computes O'Neill's entropy for a data matrix (see O'Neill et al, 1988).
}
\details{
O'Neill's entropy index is based on the transformed variable \eqn{Z}, identifying couples of realizations
of the variable of interest:
\deqn{H_O(Z)=\sum p(z_r|C) \log(1/p(z_r|C))}
where \eqn{z_r=(x_i, x_{i'})} is a generic couple of realizations of the study variable \eqn{X}.
The conditioning on \eqn{C} for grid data means that only contiguous couples are considered, i.e.
couples of pixels sharing a border.
All contiguous couples of realizations of the variable of interest are counted
and their relative frequencies are used to compute the index. The maximum value for O'Neill's entropy is
\eqn{\log(I^2)} where \eqn{I} is the number of categories of \eqn{X}. The relative version of O'Neill's entropy
is obtained by dividing the entropy value by its maximum, and is useful for comparison across datasets with
a different number of categories.
The function is able to work with grids containing missing data, specified as NA values.
All NAs are ignored in the computation and only couples of non-NA observations are considered.
}
\examples{
#numeric data, square grid
data=matrix(sample(1:5, 100, replace=TRUE), nrow=10)
oneill(data)
#plot data
plot(as.im(data, W=square(nrow(data))),
     col=grDevices::gray(seq(1,0,length.out=length(unique(c(data))))),
     main="", ribbon=TRUE)

#character data, rectangular grid
data=matrix(sample(c("a","b","c"), 300, replace=TRUE), nrow=30)
oneill(data)
#plot data
plot(as.im(data, W=owin(xrange=c(0,ncol(data)), yrange=c(0,nrow(data)))),
     col=terrain.colors(length(unique(c(data)))),
     main="", ribbon=TRUE)

#data with missing values
data=matrix(sample(1:5, 100, replace=TRUE), nrow=10)
data=rbind(rep(NA, ncol(data)), data, rep(NA, ncol(data)))
oneill(data)

}
