% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/border_segment.R
\name{border_segment}
\alias{border_segment}
\title{Border Segment Creation for FE-estimation}
\usage{
border_segment(data, cutoff, n = 10)
}
\arguments{
\item{data}{sf data frame containing point data}

\item{cutoff}{the RDD border in the form of a line (preferred) or borderpoints}

\item{n}{the number of segments to be produced}
}
\value{
a vector with factors, each category representing one segment
}
\description{
Creates \code{n} segments of a line (the RD cut-off) and assigns the closest border segment for each observation in the sf data frame.
Computationally these tasks are quite demanding when the sample size is big and thus might take a few seconds to complete.
}
\examples{
points_samp.sf <- sf::st_sample(polygon_full, 100) # create points
# make it an sf object bc st_sample only created the geometry list-column (sfc):
points_samp.sf <- sf::st_sf(points_samp.sf)
points_samp.sf$segment10 <- border_segment(points_samp.sf, cut_off, 3)

}
