% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussCrps.R
\name{GaussCrps}
\alias{GaussCrps}
\title{Calculate the Continuous Ranked Probability Score (CRPS) for forecasts issued as Normal distributions}
\usage{
GaussCrps(mean, sd, obs)
}
\arguments{
\item{mean}{A vector of length N. The forecast means.}

\item{sd}{A vector of length N. The forecast standard deviations.}

\item{obs}{A numeric vector of length N of real-valued verifying observations}
}
\value{
numeric vector of length N with the CRPS values
}
\description{
Calculate the Continuous Ranked Probability Score (CRPS) for forecasts issued as Normal distributions
}
\examples{
data(eurotempforecast)
mean <- rowMeans(ens)
sd <- apply(ens, 1, sd)
mean(GaussCrps(mean, sd, obs))
}
\references{
Gneiting et al (2005). Calibrated Probabilistic Forecasting Using Ensemble Model Output Statistics and Minimum CRPS Estimation. Mon. Wea. Rev. \doi{10.1175/MWR2904.1}
}
\seealso{
EnsCrps, DressCrps, ScoreDiff, SkillScore
}
