% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getD3dSparse.R
\name{getD3dSparse}
\alias{getD3dSparse}
\title{getD3dSparse}
\usage{
getD3dSparse(dim1, dim2, dim3)
}
\arguments{
\item{dim1}{positive integer. Based on a 3 dimensional grid, dim1 represents
the number of units represented on the first dimension}

\item{dim2}{positive integer which represents the number of units represented
on the second dimension}

\item{dim3}{positive integer which represents the number of units represented
on the third dimension}
}
\value{
a matrix with dim1 x dim2 x dim3 columns. Each row represents an
edge (a link between 2 variables) and is constructed with the couple (-1, 1),
 relative to these 2 variables and 0 for all others. In the context of a
 generalized fused lasso, this matrix penalizes only the differences in
 coefficients (fusion). To obtain parsimony in addition to the fusion, a
 diagonal matrix with the same number of columns must be bound to the
 penalty matrix constructed by getD3dSparse. This matrix will contain
 diagonally the ratio: parsimony penalty parameter on fusion penalty
 parameter. When using \code{\link[genlasso:fusedlasso]{fusedlasso}}
 function, this operation is performed when you provide the argument gamma.
}
\description{
getD3dSparse is a function that helps to construct generalized lasso
penalty matrix D when using the \code{\link[genlasso:fusedlasso]{fusedlasso}}
function over a 3 dimensional grid
}
\details{
The function returns a sparse penalty matrix providing information
on the connections between the variables during the implementation of a
generalizad fused lasso.
}
\examples{
library(genlasso)
library(Matrix)
D<-getD3dSparse(2,3,2)
plot(getGraph(D))

}
