% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_lines.R
\name{lines,Splinets-method}
\alias{lines,Splinets-method}
\title{Adding graphs of splines to a plot}
\usage{
\S4method{lines}{Splinets}(x, sID = NULL, ...)
}
\arguments{
\item{x}{\code{Splinets} object;}

\item{sID}{vector, specifying indices of splines in the splinet object to be plotted;}

\item{...}{other standard graphical parameters;}
}
\description{
A standard method of adding splines to an existing plot.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. "Dyadic diagonalization of positive definite band matrices and efficient B-spline orthogonalization." Journal of Computational and Applied Mathematics (2022) <https://doi.org/10.1016/j.cam.2022.114444>.


Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.

 Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2023) "Splinets 1.5.0 -- Periodic Splinets." <arXiv:2302.07552>
}

\examples{
#-----------------------------------------------------#
#------Adding spline lines to an existing graph-------#
#-----------------------------------------------------#
n=17; k=4; xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1 
set.seed(5)
S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))
spl=construct(xi,k,S) 
plot(spl,main="Mean Spline",lty=2,lwd=2)

RS=rspline(spl,5)
plot(RS,main="Random splines around the mean spline" )
lines(spl,col='red',lwd=4,lty=2)

}
\seealso{
\code{\link{plot,Splinets-method}} for graphical visualization of splines;
\code{\link{evspline}} for evaluation of a \code{Splinet}-object;
}
