% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.R
\name{sk.decompose}
\alias{sk.decompose}
\title{make SVD as well as orthogonal complements}
\usage{
sk.decompose(A, D)
}
\arguments{
\item{A}{the input matrix}

\item{D}{the linear transform}
}
\value{
U

S

V

U_perp: orthogonal complement for U
}
\description{
make SVD as well as orthogonal complements
}
\examples{
library(mvtnorm)
n = 350
p = 100
D <- diag(p)
Sigma = matrix(0, p, p)
X <- rmvnorm(n,matrix(0, p, 1), Sigma)
decompose.result <- sk.decompose(X, D)
U_perp <- decompose.result$U_perp
}
