% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jackknife_Variance.R
\name{Jackknife_Variance}
\alias{Jackknife_Variance}
\title{Jackknife_Variance}
\usage{
Jackknife_Variance(fit, stack, M)
}
\arguments{
\item{fit}{object with corresponding vcov method (e.g. glm, coxph, survreg, etc.) from fitting to the (weighted) stacked dataset}

\item{stack}{data frame containing stacked dataset across multiple imputations. Could have 1 or M rows for each subject with complete data. Should have M rows for each subject with imputed data. Must contain the following named columns: (1) stack$.id, which correspond to a unique identifier for each subject. This column can be easily output from MICE. (2) stack$wt, which corresponds to weights assigned to each row. Standard analysis of stacked multiple imputations should set these weights to 1 over the number of times the subject appears in the stack. (3) stack$.imp, which indicates the multiply imputed dataset (from 1 to M). This column can be easily output from MICE.}

\item{M}{number of multiple imputations}
}
\value{
Variance, estimated covariance matrix accounting for within and between imputation variation
}
\description{
This function takes a dataset with stacked multiple imputation and a model fit and applies jackknife to estimate the covariance matrix accounting for imputation uncertainty.
}
\details{
This function implements the jackknife-based estimation method for stacked multiple imputations proposed by Beesley and Taylor (2021).
}
\examples{
data(stackExample)

fit = stackExample$fit
stack = stackExample$stack

jackcovar = Jackknife_Variance(fit, stack, M = 5)
VARIANCE_jack = diag(jackcovar)

}
