% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TukeyNonaddPlot.R
\name{TukeyNonaddPlot}
\alias{TukeyNonaddPlot}
\title{Tukey Nonadditivity Plot for Two-way ANOVA}
\usage{
TukeyNonaddPlot(formula, data, out = "n",
  main = "Tukey Nonadditivity Plot", ylab = "Residuals")
}
\arguments{
\item{formula}{A formula for a two-way ANOVA in the form Response=FactorA+FactorB (or FactorA*FactorB)}

\item{data}{A dataframe}

\item{out}{Control what is returned. Default is "n"=nothing. Other options are "comp" for the comparisons, "line" for the equation of the line, and "resid" for the cell residuals.}

\item{main}{Add a title, default is "Tukey Nonadditivity Plot"}

\item{ylab}{Label vertical axis, default is "Residuals"}
}
\value{
Depends on the option set with \code{out}.
}
\description{
This function produces a Tukey nonadditivity plot for a two-way ANOVA model.
}
\details{
More details need to be written
}
\examples{
data(Dinosaurs)
TukeyNonaddPlot(Iridium~Source*factor(Depth),data=Dinosaurs)

}
